// Sample Error Translation DLL
//
// must add "ebsample" to
// HKEY_CURRENT_USER\Software\BuddyWare\Error Buddy\2.0\ErrorTypes

// ---------------------------------------------- Include files (interface)
#include "eberrdll.h"	// Our interface


BOOL EBFreeMem(void *mem)
{
	delete mem;
	return TRUE;
}

BOOL EBGetProductDescription(LPTSTR *name)
{
	*name = "Error Buddy Sample Translation DLL (c)1997 Pete Rowley";
	return TRUE;
}

BOOL EBGetErrorTypeName(LPTSTR *name)
{
	*name = "Sample";
	return TRUE;
}

BOOL EBPreferText()
{
	return FALSE;
}

BOOL EBDescribeTextError(char* pError, EBErrorTranslation **trans)
{
	return FALSE;
}

BOOL EBDescribeNumericError(unsigned long error, EBErrorTranslation **trans)
{
	*trans = new EBErrorTranslation;

	if(SUCCEEDED(error))
		(*trans)->ErrorType = "Success code";
	else
		(*trans)->ErrorType = "Error code";

	(*trans)->ErrorDesc = "This is an error";
	(*trans)->ErrorComment = "This is a comment"; // we never comment
	
	return TRUE;
}


BOOL WINAPI DllMain (HANDLE hModule,	// Handle to the module
					 ULONG  ulReason,	// Reason for the call to the DLL
					 LPVOID	lpReserved)
{
	return TRUE;
}

